/*
* :
*	rw_weather
*		0 - 
*		1 - 
*		2 - 
*		3 - 
*
*	rw_lights
*		0 - 
*		1 - 
*		2 - 
*		3 - 
*		4 - 
*		5 - 
*		6 - 
*		7 - 
*	rw_fog
*		0 - 
*		1 - 
*		2 - 
*		3 - 
*		4 - 
*/

#include <amxmodx>
#include <fakemeta>
#include <engine>

#define MAX_LIGHT_POINTS 3
#define NEXTTHINK(%1,%2)		SET_FLOAT(%1,nextthink,get_gametime()+%2)
#define GET_ORIGIN(%1,%2)		GET_VECTOR(%1,origin,%2)
#define SET_VISIBILE(%1,%2)		SET_INT(%1,effects,%2==1?GET_INT(%1,effects)&~EF_NODRAW:GET_INT(%1,effects)|EF_NODRAW)
#define DISPATCH_KEYVALUE(%1,%2,%3)	DispatchKeyValue(%1,%2,%3) 
#define SET_INT(%1,%2,%3)  	 	entity_set_int(%1,EV_INT_%2,%3)
#define GET_INT(%1,%2)			entity_get_int(%1, EV_INT_%2)
#define SET_FLOAT(%1,%2,%3)		entity_set_float(%1,EV_FL_%2,%3)
#define GET_FLOAT(%1,%2)		entity_get_float(%1,EV_FL_%2)
#define SET_VECTOR(%1,%2,%3)	 	entity_set_vector(%1,EV_VEC_%2,%3) 
#define GET_VECTOR(%1,%2,%3)		entity_get_vector(%1,EV_VEC_%2,%3)
#define SET_EDICT(%1,%2,%3) 		entity_set_edict(%1,EV_ENT_%2,%3)
#define GET_EDICT(%1,%2,%3) 		entity_get_edict(%1,EV_ENT_%2,%3)
#define SET_STRING(%1,%2,%3)		entity_set_string(%1,EV_SZ_%2,%3)
#define GET_STRING(%1,%2,%3,%4)	entity_get_string(%1,EV_SZ_%2,%3,%4)
#define FIND_ENT_BY_CLASS(%1,%2)	find_ent_by_class(%1,%2)
#define IS_VALID_ENT(%1)		is_valid_ent(%1)
#define CREATE_ENTITY(%1)		create_entity(%1)
#define REMOVE_ENTITY(%1)		remove_entity(%1)
#define SET_MODEL(%1,%2)		entity_set_model(%1,%2)
#define MDLL_SPAWN(%1)			DispatchSpawn(%1)
#define THINK(%1,%2)			register_think(%1,%2)
#define FAKE_TOUCH(%1,%2)		fake_touch(%1,%2)
#define POINTCONTENTS(%1)		point_contents(%1)
#define TRACE_LINE(%1,%2,%3,%4)	trace_line(%1,%2,%3,%4)

new weather_ent
new Float:g_strikedelay
new g_lightpoints[MAX_LIGHT_POINTS]
new g_fxbeam;
new g_soundstate[33]
new g_maxplayers;
new g_stormintensity;

public plugin_precache() 
{
	register_plugin("RealWorld", "2.4", "Authors");
	
	register_cvar("rw_weather", "0")
	register_cvar("rw_lights", "0")
	register_cvar("rw_fog", "0")
	
	g_maxplayers = get_maxplayers();

	new weather = get_cvar_num("rw_weather")
	if (weather == 1) weather = random_num(2,5)
		
	switch(weather)
	{
		case 2:
		{	
			g_fxbeam = precache_model("sprites/laserbeam.spr");
			precache_model("models/chick.mdl");
			precache_sound("ambience/rain.wav");
			precache_sound("ambience/thunder_clap.wav");
			weather_ent = CREATE_ENTITY("env_rain")
			THINK("env_rain","WeatherSystem")
			NEXTTHINK(weather_ent,1.0)
		}
		case 3: 
		{
			weather_ent = CREATE_ENTITY("env_snow");
		}
	}
	
	new lights = get_cvar_num("rw_lights")
	if (lights == 1) lights = random_num(2,7)
	switch(lights)
	{
		case 2:
		{
			new light = random_num(1,3)
			switch(light)
			{
				case 1:set_lights("b")
				case 2:set_lights("c")
				case 3:set_lights("d")
			}
			new sky = random_num(1,2)
			switch(sky)
			{
				case 1:
				{
					server_cmd("sv_skyname backalley")
					precache_generic("gfx/env/backalleyrt.tga")
					precache_generic("gfx/env/backalleylf.tga")
					precache_generic("gfx/env/backalleyft.tga")
					precache_generic("gfx/env/backalleydn.tga")
					precache_generic("gfx/env/backalleybk.tga")
					precache_generic("gfx/env/backalleyup.tga")
				}
				case 2:
				{
					server_cmd("sv_skyname space")
					precache_generic("gfx/env/spacert.tga")
					precache_generic("gfx/env/spacelf.tga")
					precache_generic("gfx/env/spaceft.tga")
					precache_generic("gfx/env/spacedn.tga")
					precache_generic("gfx/env/spacebk.tga")
					precache_generic("gfx/env/spaceup.tga")
				}
			}
		}
		case 3:
		{
			new light = random_num(1,3)
			switch(light)
			{
				case 1:set_lights("e")
				case 2:set_lights("f")
				case 3:set_lights("g")
			}
			new sky = random_num(1,2)
			switch(sky)
			{
				case 1:
				{
					server_cmd("sv_skyname hav")
					precache_generic("gfx/env/havrt.tga")
					precache_generic("gfx/env/havlf.tga")
					precache_generic("gfx/env/havft.tga")
					precache_generic("gfx/env/havdn.tga")
					precache_generic("gfx/env/havbk.tga")
					precache_generic("gfx/env/havup.tga")
				}
				case 2:
				{
					server_cmd("sv_skyname tornsky")
					precache_generic("gfx/env/tornskyrt.tga")
					precache_generic("gfx/env/tornskylf.tga")
					precache_generic("gfx/env/tornskyft.tga")
					precache_generic("gfx/env/tornskydn.tga")
					precache_generic("gfx/env/tornskybk.tga")
					precache_generic("gfx/env/tornskyup.tga")
				}
			}
		}
		case 4:
		{
			new light = random_num(1,3)
			switch(light)
			{
				case 1:set_lights("h")
				case 2:set_lights("i")
				case 3:set_lights("j")
			}
			new sky = random_num(1,4)
			switch(sky)
			{
				case 1:
				{
					server_cmd("sv_skyname blue")
					precache_generic("gfx/env/bluert.tga")
					precache_generic("gfx/env/bluelf.tga")
					precache_generic("gfx/env/blueft.tga")
					precache_generic("gfx/env/bluedn.tga")
					precache_generic("gfx/env/bluebk.tga")
					precache_generic("gfx/env/blueup.tga")
				}
				case 2:
				{
					server_cmd("sv_skyname drkg")
					precache_generic("gfx/env/drkgrt.tga")
					precache_generic("gfx/env/drkglf.tga")
					precache_generic("gfx/env/drkgft.tga")
					precache_generic("gfx/env/drkgdn.tga")
					precache_generic("gfx/env/drkgbk.tga")
					precache_generic("gfx/env/drkgup.tga")
				}
				case 3:
				{
					server_cmd("sv_skyname doom1")
					precache_generic("gfx/env/doom1rt.tga")
					precache_generic("gfx/env/doom1lf.tga")
					precache_generic("gfx/env/doom1ft.tga")
					precache_generic("gfx/env/doom1dn.tga")
					precache_generic("gfx/env/doom1bk.tga")
					precache_generic("gfx/env/doom1up.tga")
				}
				case 4:
				{
					server_cmd("sv_skyname snowlake_")
					precache_generic("gfx/env/snowlake_rt.tga")
					precache_generic("gfx/env/snowlake_lf.tga")
					precache_generic("gfx/env/snowlake_ft.tga")
					precache_generic("gfx/env/snowlake_dn.tga")
					precache_generic("gfx/env/snowlake_bk.tga")
					precache_generic("gfx/env/snowlake_up.tga")
				}
			}
		}
		case 5:
		{
			new light = random_num(1,3)
			switch(light)
			{
				case 1:set_lights("k")
				case 2:set_lights("l")
				case 3:set_lights("m")
			}
			new sky = random_num(1,3)
			switch(sky)
			{
				case 1:
				{
					server_cmd("sv_skyname morningdew")
					precache_generic("gfx/env/morningdewrt.tga")
					precache_generic("gfx/env/morningdewlf.tga")
					precache_generic("gfx/env/morningdewft.tga")
					precache_generic("gfx/env/morningdewdn.tga")
					precache_generic("gfx/env/morningdewbk.tga")
					precache_generic("gfx/env/morningdewup.tga")
				}
				case 2:
				{
					server_cmd("sv_skyname cx")
					precache_generic("gfx/env/cxrt.tga")
					precache_generic("gfx/env/cxlf.tga")
					precache_generic("gfx/env/cxft.tga")
					precache_generic("gfx/env/cxdn.tga")
					precache_generic("gfx/env/cxbk.tga")
					precache_generic("gfx/env/cxup.tga")
				}
				case 3:
				{
					server_cmd("sv_skyname snow")
					precache_generic("gfx/env/snowrt.tga")
					precache_generic("gfx/env/snowlf.tga")
					precache_generic("gfx/env/snowft.tga")
					precache_generic("gfx/env/snowdn.tga")
					precache_generic("gfx/env/snowbk.tga")
					precache_generic("gfx/env/snowup.tga")
				}
			}
		}
		case 6:
		{
			new light = random_num(1,3)
			switch(light)
			{
				case 1:set_lights("n")
				case 2:set_lights("o")
				case 3:set_lights("p")
			}
			new sky = random_num(1,2)
			switch(sky)
			{
				case 1:
				{
					server_cmd("sv_skyname grnplsnt")
					precache_generic("gfx/env/grnplsntrt.tga")
					precache_generic("gfx/env/grnplsntlf.tga")
					precache_generic("gfx/env/grnplsntft.tga")
					precache_generic("gfx/env/grnplsntdn.tga")
					precache_generic("gfx/env/grnplsntbk.tga")
					precache_generic("gfx/env/grnplsntup.tga")
				}
				case 2:
				{
					server_cmd("sv_skyname des")
					precache_generic("gfx/env/desrt.tga")
					precache_generic("gfx/env/deslf.tga")
					precache_generic("gfx/env/desft.tga")
					precache_generic("gfx/env/desdn.tga")
					precache_generic("gfx/env/desbk.tga")
					precache_generic("gfx/env/desup.tga")
				}
		}
			}
		case 7:
		{
			new light = random_num(1,3)
			switch(light)
			{
				case 1:set_lights("q")
				case 2:set_lights("r")
				case 3:set_lights("s")
			}
			new sky = random_num(1,2)
			switch(sky)
			{
				case 1:
				{
					server_cmd("sv_skyname green")
					precache_generic("gfx/env/greenrt.tga")
					precache_generic("gfx/env/greenlf.tga")
					precache_generic("gfx/env/greenft.tga")
					precache_generic("gfx/env/greendn.tga")
					precache_generic("gfx/env/greenbk.tga")
					precache_generic("gfx/env/greenup.tga")
				}
				case 2:
				{
					server_cmd("sv_skyname trainyard")
					precache_generic("gfx/env/trainyardrt.tga")
					precache_generic("gfx/env/trainyardlf.tga")
					precache_generic("gfx/env/trainyardft.tga")
					precache_generic("gfx/env/trainyarddn.tga")
					precache_generic("gfx/env/trainyardbk.tga")
					precache_generic("gfx/env/trainyardup.tga")
				}
			}
		}
	}
	
	new fog = get_cvar_num("rw_fog")
	if (fog == 1) fog = random_num(2,7)
	switch(fog)
	{
		case 2:
		{
			new fog = engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString, "env_fog"))
			if(fog)
			{
				fm_set_kvd(fog, "density", "0.0005", "env_fog")
				fm_set_kvd(fog, "rendercolor", "128 128 128", "env_fog")
			}
		}
		case 3:
		{
			new fog = engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString, "env_fog"))
			if(fog)
			{
				fm_set_kvd(fog, "density", "0.0010", "env_fog")
				fm_set_kvd(fog, "rendercolor", "128 128 128", "env_fog")
			}
		}
		case 4:
		{
			new fog = engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString, "env_fog"))
			if(fog)
			{
				fm_set_kvd(fog, "density", "0.0015", "env_fog")
				fm_set_kvd(fog, "rendercolor", "128 128 128", "env_fog")
			}
		}
	}

	set_task(15.0, "sky_color")
}

public client_putinserver(id)
{
	client_cmd(id, "sv_skycolor_r 0");
	client_cmd(id, "sv_skycolor_g 0");
	client_cmd(id, "sv_skycolor_b 0");
	client_cmd(id, "cl_weather 1");
}

public sky_color()
{
	server_cmd("sv_skycolor_r 0")
	server_cmd("sv_skycolor_g 0")
	server_cmd("sv_skycolor_b 0")
}

public WeatherSystem(entid)
{
	if(entid == weather_ent) 
	{
		g_stormintensity = 50;
		
		new victim = GetSomeoneUnworthy(); 
		
		if(g_stormintensity) 
		{
			if(g_strikedelay < get_gametime()) 
			{
				if(victim)
				{
					CreateLightningPoints(victim);
				}
			}
		}
		NEXTTHINK(weather_ent,2.0)
	}
	return PLUGIN_CONTINUE
}

GetSomeoneUnworthy()
{
	new cnt, id, total[33];
	for(id=1;id<g_maxplayers;id++)
		if(is_user_alive(id))
			if(is_user_outside(id)) 
			{
				total[cnt++] = id;	
				
				if(!g_soundstate[id])
				{
					g_soundstate[id] = 1;
					client_cmd(id, "speak ambience/rain.wav");
				}	
			}
			else if(g_soundstate[id]) 
			{
				g_soundstate[id] = 0;
				client_cmd(id, "speak NULL")
			}
	
	if(cnt)
		return total[random_num(0, (cnt-1))];
	return 0;
}

CreateLightningPoints(victim) 
{
	if(IS_VALID_ENT(g_lightpoints[0]))
		return 0;
		
	new ent, x, Float:tVel[3];
	new Float:vOrig[3];
	new Float:mins[3] = { -1.0, -1.0, -1.0 };
	new Float:maxs[3] = { 1.0, 1.0, 1.0 };
	new Float:dist = is_user_outside(victim)-5;
	
	GET_ORIGIN(victim,vOrig)
	if(dist > 700.0)
	{
		dist = 700.0;
	}
	vOrig[2] += dist;

	for(x=0;x<MAX_LIGHT_POINTS;x++) 
	{
		ent = CREATE_ENTITY("env_sprite")
		SET_INT(ent,movetype,MOVETYPE_FLY)
		SET_INT(ent,solid,SOLID_TRIGGER)
		SET_FLOAT(ent,renderamt,0.0)
		SET_INT(ent,rendermode,kRenderTransAlpha)
		SET_MODEL(ent,"models/chick.mdl")
		
		SET_VECTOR(ent,mins,mins)
		SET_VECTOR(ent,maxs,maxs)
		tVel[0] = random_float(-500.0,500.0);
		tVel[1] = random_float(-500.0,500.0);
		tVel[2] = random_float((dist<=700.0?0.0:-100.0),(dist<=700.0?0.0:50.0));
		
		SET_VECTOR(ent,origin,vOrig)
		SET_VECTOR(ent,velocity,tVel)
		g_lightpoints[x] = ent;
	}
	emit_sound(ent, CHAN_STREAM, "ambience/thunder_clap.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
	set_task(random_float(0.6,2.0),"Lightning",victim);
	return 1;
}

public Lightning(victim) 
{
	new x, a, b, rand;
	new endpoint = MAX_LIGHT_POINTS-1;
	while(x < endpoint)
	{
		a = g_lightpoints[x];
		b = g_lightpoints[x+1];
		x++
		if(x == endpoint)
		{
			rand = random_num(1,1000);
			if(rand == 1)
			{
				b = victim;
				FAKE_DAMAGE(victim,"Lightning",100.0,1);
			}
		}
		CreateBeam(a,b);
	}
	
	for(x=0;x<MAX_LIGHT_POINTS;x++)
		if(IS_VALID_ENT(g_lightpoints[x]))
			REMOVE_ENTITY(g_lightpoints[x])
	
	
	if(g_stormintensity > 100)
	{
		set_cvar_num("weather_storm", 100);
		g_stormintensity = 100;	
	}
	new Float:mins = 50.0-float(g_stormintensity/2);
	new Float:maxs = 50.0-float(g_stormintensity/3);
	g_strikedelay = get_gametime() + random_float(mins, maxs);
}

Float:is_user_outside(id)
{
	new Float:origin[3], Float:dist;
	GET_ORIGIN(id, origin)
	
	dist = origin[2];
	
	while (POINTCONTENTS(origin) == -1)
		origin[2] += 5.0;

	if (POINTCONTENTS(origin) == -6) return (origin[2]-dist);
	return 0.0;
}

CreateBeam(entA, entB)
{
	message_begin( MSG_BROADCAST, SVC_TEMPENTITY );
	write_byte( 8 );
	write_short( entA );
	write_short( entB );
	write_short( g_fxbeam );
	write_byte(0);
	write_byte(10);
	write_byte(5); 
	write_byte(8);
	write_byte(100);
	write_byte(255);
	write_byte(255);
	write_byte(255);
	write_byte(255)
	write_byte(10);
	message_end();
}

stock fm_set_kvd(entity, const key[], const value[], const classname[] = "") 
{
	set_kvd(0, KV_ClassName, classname), set_kvd(0, KV_KeyName, key)
	set_kvd(0, KV_Value, value), set_kvd(0, KV_fHandled, 0)

	return dllfunc(DLLFunc_KeyValue, entity, 0)
}

stock FAKE_DAMAGE(idvictim,szClassname[],Float:takedmgdamage,damagetype)
{
	new entity = CREATE_ENTITY("trigger_hurt")
	if (entity)
	{
		new szDamage[16]
		format(szDamage,15,"%f",takedmgdamage * 2)
		DISPATCH_KEYVALUE(entity,"dmg",szDamage)
		format(szDamage,15,"%i",damagetype)
		DISPATCH_KEYVALUE(entity,"damagetype",szDamage)
		MDLL_SPAWN(entity)
		SET_STRING(entity,classname,szClassname)
		FAKE_TOUCH(entity,idvictim)
		REMOVE_ENTITY(entity)
		return 1
	}
	return 0
}
