#include <amxmodx>
#include <cstrike>
#include <fakemeta>
#include <hamsandwich>
#include <amxmisc>

#pragma semicolon 1

#define MAX_PLAYERS 32

#define BIT_VALID(%1,%2) ((%1) & (1 << ((%2) - 1)))
#define BIT_ADD(%1,%2) ((%1) |= (1 << ((%2) - 1)))
#define BIT_SUB(%1,%2) ((%1) &= ~(1 << ((%2) - 1)))
#define BIT_NOT_VALID(%1,%2) (~(%1) & (1 << ((%2) - 1)))

new g_iBitClientAccess, g_iBitCustomModel;

///модели для steam игроков, плагин работает только с dproto.
new const model_CT[] = "st_ct";	// Название модели для CT
new const model_TE[] = "st_t";	// Название модели для T

public plugin_init()
{
///////original code///////
//	register_plugin("Lady Models", "0.1b", "Freedo.m");
///////original code///////

	register_plugin("Steam Models", "0.1b+mod.leg", "Freedo.m");
	RegisterHam(Ham_Spawn, "player", "Ham_PlayerSpawn_Post", 1);
	register_forward(FM_SetClientKeyValue, "FM_SetClientKeyValue_Pre", 0);
}

public plugin_precache()
{
	//// Author ill ?)
	new buffer[128];
	formatex(buffer, charsmax(buffer), "models/player/st_ct/st_ct.mdl", model_CT, model_CT);
	precache_model(buffer);
	formatex(buffer, charsmax(buffer), "models/player/st_t/st_t.mdl", model_TE, model_TE);
	precache_model(buffer);
}

public client_putinserver(id)
{
	if (is_user_steam(id))
		BIT_ADD(g_iBitClientAccess, id);
}

public client_disconnect(id)
{
	BIT_SUB(g_iBitClientAccess, id);
	BIT_SUB(g_iBitCustomModel, id);
}

public Ham_PlayerSpawn_Post(id)
{
	if(BIT_VALID(g_iBitClientAccess, id) && is_user_alive(id))
	{
		switch(cs_get_user_team(id))
		{
			case CS_TEAM_T: fm_cs_set_user_model(id, model_TE);
			case CS_TEAM_CT: fm_cs_set_user_model(id, model_CT);
		}
	}
}

new g_szPlayerModel[MAX_PLAYERS + 1][32];

public FM_SetClientKeyValue_Pre(id, const szInfobuffer[], const szKey[])
{
	if(BIT_VALID(g_iBitCustomModel, id) && equal(szKey, "model"))
	{
		static szCurrentModel[32];
		fm_cs_get_user_model(id, szCurrentModel, charsmax(szCurrentModel));
		if(!equal(szCurrentModel, g_szPlayerModel[id])) fm_cs_set_user_model(id, g_szPlayerModel[id]);
		return FMRES_SUPERCEDE;
	}
	return FMRES_IGNORED;
}

stock fm_cs_get_user_model(id, szModel[], szLen) engfunc(EngFunc_InfoKeyValue, engfunc(EngFunc_GetInfoKeyBuffer, id), "model", szModel, szLen);
stock fm_cs_set_user_model(id, const szModelName[])
{
	engfunc(EngFunc_SetClientKeyValue, id, engfunc(EngFunc_GetInfoKeyBuffer, id), "model", szModelName);
	copy(g_szPlayerModel[id], charsmax(g_szPlayerModel[]), szModelName);
	BIT_ADD(g_iBitCustomModel, id);
}

stock fm_cs_reset_user_model(id)
{
	BIT_SUB(g_iBitCustomModel, id);
	dllfunc(DLLFunc_ClientUserInfoChanged, id, engfunc(EngFunc_GetInfoKeyBuffer, id));
}

stock bool:is_user_steam(id)
{
	// Author Sh0oter
	static dp_pointer;
	if(dp_pointer || (dp_pointer = get_cvar_pointer("dp_r_id_provider")))
	{
		server_cmd("dp_clientinfo %d", id);
		server_exec();
		return (get_pcvar_num(dp_pointer) == 2) ? true : false ;
	}
	return false;
}