// About this plugin and all updates http://www.amx-x.ru/viewtopic.php?f=12&t=35119

#include <amxmodx>
#include <cstrike>
#include <dhudmessage>

#define PLUGIN "OptimizeTeams"
#define VERSION "1.6fix1"
#define AUTHOR "Burberry"

enum _: UserData
{
	bool: CSDM_TOTRANSFER,
	RKILLS,
	TRANSF_TIME
}

enum pCvars 
{ 
	CSDM, 
	CSDM_LIMIT_PERCENT,
	CSDM_EXCHANGE_PERCENT,
	CSDM_INST,
	CSDM_CHECK_TIMER,
	
	BALANCE_ONLINE,
	BALANCE_LIMIT, 
	BALANCE_EXCHANGE_LIMIT,
	WAIT_ROUNDS, 
	TRANSFER_FREQ
}

new eInfoUser[UserData][33], eCvars[pCvars];

new 
	g_iPlayersMax, 
	g_iCTscore, 
	g_iTscore, 
	g_iWaitRounds;

public plugin_init()
{
	register_plugin(PLUGIN, VERSION, AUTHOR);
	register_cvar(PLUGIN, VERSION, FCVAR_SERVER|FCVAR_SPONLY);
	
	register_event("DeathMsg",	"EventDeath", "a");
	register_event("TextMsg",	"EventClear", "a", "2&#Game_C", "2&#Game_w");
	
	//we are register cvars specially in plugin_init
	eCvars[CSDM] =			register_cvar("opteams_csdm", "0");
	eCvars[CSDM_LIMIT_PERCENT] =	register_cvar("opteams_csdm_limitpercent", "30"); 
	eCvars[CSDM_EXCHANGE_PERCENT] =	register_cvar("opteams_csdm_exchangepercent", "40"); 
	eCvars[CSDM_INST] = 		register_cvar("opteams_csdm_inst", "1");
	eCvars[CSDM_CHECK_TIMER] =	register_cvar("opteams_csdm_checktimer", "3");
	eCvars[TRANSFER_FREQ] =		register_cvar("opteams_transfer_freq", "10");
	eCvars[BALANCE_ONLINE] = 	register_cvar("opteams_online", "10");
	eCvars[BALANCE_LIMIT] =		register_cvar("opteams_balance_limit", "5");
	eCvars[BALANCE_EXCHANGE_LIMIT]=	register_cvar("opteams_balance_exchangelimit", "15");
	eCvars[WAIT_ROUNDS] =		register_cvar("opteams_wait_rounds", "2");
	
	g_iPlayersMax =	get_maxplayers();
}

public plugin_cfg() // this calling after plugin_init and we get settings from cfg file
{
	new szConfigsDir[128];
	get_localinfo( "amxx_configsdir", szConfigsDir, charsmax(szConfigsDir) );
	
	add( szConfigsDir, charsmax(szConfigsDir), "/opteams.cfg" );
	
	if( file_exists( szConfigsDir ) ) // anti "couldn't exec" message check
	{
		server_cmd( "exec %s", szConfigsDir );
		server_exec();
	}
	
	if( !get_pcvar_num( eCvars[CSDM] ) )
	{
		register_event("TeamScore", "EventScore", "a");
		register_logevent("EventRoundEnd", 2, "1=Round_End");
	}
	else	set_task( get_pcvar_float( eCvars[CSDM_CHECK_TIMER] ) * 60, "CSDM_Look", _, _, _, "b" );
		
	g_iWaitRounds =	get_pcvar_num( eCvars[WAIT_ROUNDS] );
}

public EventClear()
{
	for ( new id = 1 ; id < 33; id ++ )
		client_putinserver( id ); // clear integers values
}

public EventScore() 
{ 
	new sTeam[1];
	read_data(1, sTeam, 1);

	if( sTeam[0] == 'C' ) 
		g_iCTscore =	read_data( 2 );
	else 	g_iTscore  =	read_data( 2 );
}

public EventRoundEnd()
{
	if( g_iWaitRounds )
		g_iWaitRounds --;
	else
	{
		g_iWaitRounds = get_pcvar_num( eCvars[WAIT_ROUNDS] );
		
		new iSum = g_iCTscore - g_iTscore, iTrTeam;
		
		if( iSum >= get_pcvar_num( eCvars[BALANCE_LIMIT] ) ) // CT check
		{
			iTrTeam = 2;
		}
		else
		{
			iSum = g_iTscore - g_iCTscore;
			
			if( iSum >= get_pcvar_num( eCvars[BALANCE_LIMIT] ) ) // T check
			{
				iTrTeam = 1;
			}
			else return;
		}
			
		
		TransferFromTeam( iTrTeam, true );
			
		if( iSum <= get_pcvar_num( eCvars[BALANCE_EXCHANGE_LIMIT] ) )
		TransferFromTeam( iTrTeam == 1 ? 2 : 1, false );
	}
}

public CSDM_Look()
{
	new iFragsT, iFragsCT;
	
	for ( new id = 1; id <= g_iPlayersMax; id ++ )
	{
		if ( is_user_connected(id) )
		{
			if( get_user_team( id ) == 1 )
				iFragsT  +=	eInfoUser[RKILLS][id];
			else
			if( get_user_team( id ) == 2 )
				iFragsCT +=	eInfoUser[RKILLS][id];
		}
	}
	
	// Divide error fix, for some fantastic situations and bad cvar parameters
	if( !iFragsT )	iFragsT = 1;
	if( !iFragsCT )	iFragsCT = 1;
	
	new iSum, iTrTeam;
	
	if( iFragsT > iFragsCT )
	{
		iTrTeam = 1;	
		iSum = 100 - (iFragsCT / iFragsT) * 100;
	}
	else
	if( iFragsCT > iFragsT )
	{
		iTrTeam = 2;
		iSum = 100 - (iFragsT / iFragsCT) * 100;
	}
	else 	return;
	
	if( iSum >= get_pcvar_num( eCvars[CSDM_LIMIT_PERCENT] ) )
	{
		TransferFromTeam( iTrTeam, true );
		
		if( iSum <= get_pcvar_num( eCvars[CSDM_EXCHANGE_PERCENT] ) )
		TransferFromTeam( iTrTeam == 1 ? 2 : 1, false );
	}
}

public EventDeath()
{
	new pVic; pVic = read_data( 2 );
	
	eInfoUser[RKILLS][ read_data( 1 ) ]  ++;
	
	if( eInfoUser[CSDM_TOTRANSFER][pVic] )
	{
		TransfAtNow( pVic );
		eInfoUser[CSDM_TOTRANSFER][pVic] = false;	
	}
}

public client_putinserver(id)
{
	eInfoUser[TRANSF_TIME][id] = 0;
	eInfoUser[RKILLS][id] = 0;
	eInfoUser[CSDM_TOTRANSFER][id] = false;
}

TransferFromTeam(iTeam, bool: strong) // From which team and his power.
{
	new iFrags = strong ? 0 : 1000, iIDplayer, iIDPrev;
	
	for ( new id = 1; id <= g_iPlayersMax; id ++ )
	{
		if( is_user_connected(id) && !( get_user_flags(id) & ADMIN_IMMUNITY ) )
		{
			if( get_user_team(id) == iTeam && CanTransfer(id) )
			{
				if( strong )
				{
					if( iFrags <= eInfoUser[RKILLS][id] )
					{
						iFrags = eInfoUser[RKILLS][id];
						iIDPrev = iIDplayer;
						iIDplayer = id;
					}
				}
				else
				{
					if( iFrags >= eInfoUser[RKILLS][id] )
					{
						iFrags = eInfoUser[RKILLS][id];
						iIDplayer = id;
					}
				}
			}
		}
	}
	
	/* No has effect when 'strong' is false.
	Transfer weaker player if we have him.
	This is done to tranfer not the strongest player. */
	if( iIDPrev ) 
		iIDplayer = iIDPrev; 
	
	if( is_user_connected(iIDplayer) )
	{
			if( !get_pcvar_num( eCvars[CSDM] ) )
			{
				TransfAtNow(iIDplayer);
			}
			else
			{
				if( get_pcvar_num( eCvars[CSDM_INST] ) )
				{
					TransfAtNow(iIDplayer); // we can make it above this
				}
				else
				{
					eInfoUser[CSDM_TOTRANSFER][iIDplayer] = true;
				}
			}
	}
}

CanTransfer(id)
{
	return get_systime() - eInfoUser[TRANSF_TIME][id] >= get_pcvar_float( eCvars[TRANSFER_FREQ] ) * 60;
}

TransfAtNow(iIDplayer)
{
	if ( get_playersnum() < get_pcvar_num( eCvars[ BALANCE_ONLINE ] ) ) return;
	
	eInfoUser[TRANSF_TIME][iIDplayer] = get_systime(); // set last transfer time
	
	if( is_user_alive(iIDplayer) ) 
		user_silentkill(iIDplayer); //  
				
	cs_set_user_team(iIDplayer, get_user_team(iIDplayer) == 1 ? CS_TEAM_CT : CS_TEAM_T);
	ShowMessage( iIDplayer );
}

ShowMessage(id)
{
	static Float: flPosY = 0.60; // For anti strings imposition
	
	if( flPosY == 0.60 )
		flPosY = 0.66 // 0.03 + 0.03 ( we send two strings message two times, sometimes )
	else	flPosY = 0.60
	
	new szName[32];
	get_user_name(id, szName, 31);
	
	set_dhudmessage(200, 200, 0, -1.0, flPosY, 0, 1.0, 6.0, 1.0, 2.0);
	show_dhudmessage(0, "%s^nWAS TRANSFERRED TO DIFFERENT TEAM", szName);
}
